/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;
import net.adventurez.entity.PiglinBeastEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@Environment(value=EnvType.CLIENT)
public class PiglinBeastModel<T extends PiglinBeastEntity>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftHorn;
    private final ModelPart rightHorn;
    private final ModelPart leftEar;
    private final ModelPart rightEar;
    private final ModelPart flagHolder;
    private final ModelPart flag;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public PiglinBeastModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.rightEar = this.head.m_171324_("rightEar");
        this.leftEar = this.head.m_171324_("leftEar");
        this.rightHorn = this.head.m_171324_("rightHorn");
        this.leftHorn = this.head.m_171324_("leftHorn");
        this.body = root.m_171324_("body");
        this.flagHolder = this.body.m_171324_("flagHolder");
        this.flag = this.flagHolder.m_171324_("flag");
        this.leftArm = root.m_171324_("leftArm");
        this.rightArm = root.m_171324_("rightArm");
        this.leftLeg = root.m_171324_("leftLeg");
        this.rightLeg = root.m_171324_("rightLeg");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData1 = modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(74, 0).m_171481_(-5.0f, -11.0f, -5.0f, 10.0f, 9.0f, 10.0f).m_171514_(57, 11).m_171481_(3.0f, -5.0f, -6.0f, 3.0f, 2.0f, 1.0f).m_171514_(48, 56).m_171481_(-6.0f, -5.0f, -6.0f, 3.0f, 2.0f, 1.0f).m_171514_(0, 38).m_171481_(-3.0f, -7.0f, -6.0f, 6.0f, 4.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)-16.0f, (float)-1.0f));
        modelPartData1.m_171599_("leftHorn", CubeListBuilder.m_171558_().m_171514_(51, 30).m_171481_(-4.7379f, 1.2403f, 0.62f, 6.0f, 2.0f, 1.0f), PartPose.m_171419_((float)-3.0f, (float)-6.0f, (float)-7.0f));
        modelPartData1.m_171599_("rightHorn", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.8264f, 1.6629f, -0.3197f, 6.0f, 2.0f, 1.0f), PartPose.m_171419_((float)3.0f, (float)-7.0f, (float)-6.0f));
        modelPartData1.m_171599_("hair", CubeListBuilder.m_171558_().m_171514_(61, 32).m_171481_(-3.0f, -8.0f, 6.0f, 0.0f, 4.0f, 1.0f).m_171514_(0, 51).m_171481_(-3.0f, -7.0f, 8.0f, 0.0f, 3.0f, 1.0f).m_171514_(10, 51).m_171481_(-3.0f, -9.0f, 4.0f, 0.0f, 5.0f, 1.0f).m_171514_(50, 46).m_171481_(-3.0f, -6.0f, 10.0f, 0.0f, 2.0f, 1.0f).m_171514_(48, 48).m_171481_(-3.0f, 1.0f, 11.0f, 0.0f, 1.0f, 3.0f).m_171514_(8, 45).m_171481_(-3.0f, -1.0f, 11.0f, 0.0f, 1.0f, 2.0f).m_171514_(13, 12).m_171481_(-3.0f, -3.0f, 11.0f, 0.0f, 1.0f, 2.0f).m_171514_(0, 49).m_171481_(-3.0f, -4.0f, 11.0f, 0.0f, 1.0f, 1.0f).m_171514_(8, 41).m_171481_(-3.0f, -2.0f, 11.0f, 0.0f, 1.0f, 3.0f).m_171514_(0, 40).m_171481_(-3.0f, 0.0f, 11.0f, 0.0f, 1.0f, 4.0f).m_171514_(0, 39).m_171481_(-3.0f, 2.0f, 11.0f, 0.0f, 1.0f, 4.0f).m_171514_(8, 40).m_171481_(-3.0f, 3.0f, 11.0f, 0.0f, 1.0f, 3.0f).m_171514_(13, 37).m_171481_(-3.0f, 4.0f, 11.0f, 0.0f, 1.0f, 1.0f).m_171514_(61, 1).m_171481_(-3.0f, -8.0f, 2.0f, 0.0f, 4.0f, 1.0f).m_171514_(48, 46).m_171481_(-3.0f, -6.0f, 3.0f, 0.0f, 2.0f, 1.0f).m_171514_(0, 29).m_171481_(-3.0f, -7.0f, 5.0f, 0.0f, 3.0f, 1.0f).m_171514_(14, 14).m_171481_(-3.0f, -6.0f, 7.0f, 0.0f, 2.0f, 1.0f).m_171514_(2, 49).m_171481_(-3.0f, -5.0f, 9.0f, 0.0f, 1.0f, 1.0f), PartPose.m_171419_((float)3.0f, (float)-7.0f, (float)-6.0f));
        modelPartData1.m_171599_("leftEar", CubeListBuilder.m_171558_().m_171514_(57, 0).m_171481_(-5.0f, -1.0f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.m_171419_((float)-5.0f, (float)-8.0f, (float)0.0f));
        modelPartData1.m_171599_("rightEar", CubeListBuilder.m_171558_().m_171514_(48, 49).m_171481_(-5.0f, -0.0603f, -3.0f, 6.0f, 1.0f, 6.0f), PartPose.m_171419_((float)5.0f, (float)-8.0f, (float)0.0f));
        PartDefinition modelPartData2 = modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(47, 56).m_171481_(-8.0f, 12.0f, -8.0f, 18.0f, 3.0f, 13.0f).m_171514_(0, 30).m_171481_(-8.0f, 10.0f, -9.0f, 18.0f, 2.0f, 15.0f).m_171514_(0, 0).m_171481_(-9.0f, -3.0f, -10.0f, 20.0f, 13.0f, 17.0f).m_171514_(74, 19).m_171481_(-9.0f, 10.0f, -10.0f, 20.0f, 10.0f, 0.0f).m_171514_(72, 72).m_171481_(-9.0f, 10.0f, 7.0f, 20.0f, 10.0f, 0.0f).m_171514_(29, 55).m_171481_(11.0f, 10.0f, -10.0f, 0.0f, 10.0f, 17.0f).m_171514_(29, 55).m_171481_(-9.0f, 10.0f, -10.0f, 0.0f, 10.0f, 17.0f).m_171514_(52, 33).m_171481_(-8.0f, -5.0f, -7.0f, 18.0f, 2.0f, 14.0f).m_171514_(0, 47).m_171481_(-8.0f, -15.0f, -5.0f, 18.0f, 10.0f, 12.0f), PartPose.m_171419_((float)-1.0f, (float)-3.0f, (float)1.0f));
        PartDefinition modelPartData3 = modelPartData2.m_171599_("flagHolder", CubeListBuilder.m_171558_().m_171514_(76, 95).m_171481_(-2.0f, -37.9319f, 0.4824f, 2.0f, 29.0f, 2.0f).m_171514_(46, 72).m_171481_(-3.0f, -42.0f, -1.0f, 4.0f, 5.0f, 18.0f).m_171514_(0, 0).m_171481_(-3.0f, -8.9319f, -0.5176f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)4.0f, (float)8.0f, (float)6.0f));
        modelPartData3.m_171599_("flag", CubeListBuilder.m_171558_().m_171514_(0, 79).m_171481_(0.0f, -0.6136f, -6.8755f, 0.0f, 24.0f, 14.0f), PartPose.m_171419_((float)-1.0f, (float)-38.0f, (float)9.0f));
        modelPartData.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(28, 93).m_171481_(-3.3939f, -1.3963f, -3.0f, 5.0f, 24.0f, 6.0f), PartPose.m_171419_((float)-9.0f, (float)-15.0f, (float)2.0f));
        modelPartData.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(84, 89).m_171481_(-0.899f, -1.1716f, -3.0f, 5.0f, 25.0f, 6.0f).m_171514_(101, 71).m_171481_(0.8422f, 18.7943f, -6.0f, 2.0f, 3.0f, 11.0f).m_171514_(51, 39).m_171481_(-0.1578f, 18.7943f, -8.0f, 3.0f, 4.0f, 2.0f).m_171514_(0, 30).m_171481_(-0.1578f, 17.7943f, -11.0f, 4.0f, 5.0f, 3.0f).m_171514_(0, 69).m_171481_(-1.1578f, 16.7943f, -28.0f, 6.0f, 7.0f, 17.0f).m_171514_(51, 33).m_171481_(-0.1578f, 17.7943f, -29.0f, 4.0f, 5.0f, 1.0f).m_171514_(64, 13).m_171481_(1.3951f, 15.9987f, -14.0f, 3.0f, 1.0f, 1.0f).m_171514_(57, 7).m_171481_(0.3951f, 15.9987f, -21.0f, 1.0f, 1.0f, 3.0f).m_171514_(12, 0).m_171481_(1.361f, 14.2576f, -27.0f, 1.0f, 3.0f, 1.0f).m_171514_(0, 0).m_171481_(3.5517f, 13.8093f, -24.0f, 1.0f, 3.0f, 1.0f).m_171514_(11, 30).m_171481_(2.5858f, 14.5505f, -19.0f, 1.0f, 2.0f, 1.0f).m_171514_(57, 0).m_171481_(4.9319f, 17.5176f, -24.0f, 2.0f, 1.0f, 1.0f).m_171514_(48, 52).m_171481_(4.6731f, 18.4836f, -16.0f, 2.0f, 1.0f, 1.0f).m_171514_(0, 56).m_171481_(4.3801f, 19.7083f, -25.0f, 4.0f, 1.0f, 1.0f).m_171514_(64, 10).m_171481_(4.0f, 21.6401f, -24.0f, 3.0f, 1.0f, 1.0f).m_171514_(0, 52).m_171481_(3.5f, 21.6401f, -17.0f, 2.0f, 1.0f, 3.0f).m_171514_(57, 2).m_171481_(3.3449f, 23.572f, -26.0f, 1.0f, 2.0f, 1.0f).m_171514_(56, 56).m_171481_(0.4471f, 23.7955f, -24.0f, 1.0f, 2.0f, 1.0f).m_171514_(0, 47).m_171481_(1.413f, 23.7f, -19.0f, 1.0f, 2.0f, 1.0f).m_171514_(8, 48).m_171481_(2.3789f, 23.3131f, -16.0f, 1.0f, 2.0f, 1.0f).m_171514_(62, 7).m_171481_(-2.9331f, 21.0872f, -27.0f, 3.0f, 1.0f, 1.0f).m_171514_(57, 14).m_171481_(-3.3813f, 18.8965f, -23.0f, 3.0f, 1.0f, 1.0f).m_171514_(48, 49).m_171481_(-2.1225f, 17.9306f, -16.0f, 2.0f, 1.0f, 1.0f).m_171514_(0, 47).m_171481_(-2.3813f, 19.8965f, -18.0f, 2.0f, 1.0f, 4.0f), PartPose.m_171419_((float)8.0f, (float)-15.0f, (float)2.0f));
        modelPartData.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(96, 49).m_171481_(-3.0f, 0.0f, -4.0f, 6.0f, 13.0f, 7.0f), PartPose.m_171419_((float)-3.9f, (float)11.0f, (float)0.0f));
        modelPartData.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(50, 95).m_171481_(-3.0f, 0.0f, -4.0f, 6.0f, 13.0f, 7.0f), PartPose.m_171419_((float)3.9f, (float)11.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)128);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightArm, (Object)this.leftArm);
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float handUp;
        this.head.f_104204_ = headYaw * 0.007945329f;
        this.head.f_104203_ = headPitch * 0.0027453292f;
        this.leftHorn.f_104204_ = -0.3491f;
        this.leftHorn.f_104205_ = 1.1345f;
        this.rightHorn.f_104204_ = 0.3491f;
        this.rightHorn.f_104205_ = -1.1345f;
        this.leftEar.f_104205_ = -1.1345f;
        this.rightEar.f_104205_ = -1.9199f;
        this.leftArm.f_104205_ = 0.2618f;
        this.rightArm.f_104205_ = -0.2618f;
        this.flagHolder.f_104203_ = -0.2618f;
        this.flag.f_104203_ = 0.1745f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 1.4f * limbDistance;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 1.4f * limbDistance;
        this.flag.f_104205_ = Mth.m_14089_((float)(animationProgress / 10.0f)) / 4.0f;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 2.0f * limbDistance * 0.3f;
        this.leftArm.f_104203_ = -Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 2.0f * limbDistance * 0.3f;
        float attackTick = ((Float)entity.m_20088_().m_135370_(PiglinBeastEntity.ATTACK_TICK_VISUAL)).floatValue();
        if (attackTick > 0.0f) {
            float g = attackTick;
            float h = Mth.m_14031_((float)(g * (float)Math.PI));
            float i = Mth.m_14031_((float)(attackTick * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            this.rightArm.f_104203_ = (float)((double)this.rightArm.f_104203_ - ((double)h * 1.2 + (double)i));
            this.rightArm.f_104205_ += Mth.m_14031_((float)(attackTick * (float)Math.PI)) * -0.4f - limbDistance;
        }
        if ((handUp = ((Float)entity.m_20088_().m_135370_(PiglinBeastEntity.LEAD_ARM)).floatValue()) > 0.0f) {
            float g = handUp;
            float h = Mth.m_14031_((float)(g * (float)Math.PI));
            float i = Mth.m_14031_((float)(handUp * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            this.leftArm.f_104203_ = (float)((double)this.leftArm.f_104203_ - ((double)h * 1.2 + (double)i));
        }
        this.rightEar.f_104205_ += Mth.m_14089_((float)((limbAngle * 0.6662f + (float)Math.PI) / 3.0f)) * limbDistance / 2.0f;
        this.leftEar.f_104205_ -= Mth.m_14089_((float)((limbAngle * 0.6662f + (float)Math.PI) / 3.0f)) * limbDistance / 2.0f;
    }
}

